<?php

function check_email_address($email)
{
    // First, we check that there's one @ symbol, 
    // and that the lengths are right.
    if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email))
    {
        // Email invalid because wrong number of characters 
        // in one section or wrong number of @ symbols.
        return false;
    }
    // Split it into sections to make life easier
    $email_array = explode("@", $email);
    $local_array = explode(".", $email_array[0]);
    for ($i = 0; $i < sizeof($local_array); $i++)
    {
        if
        (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&
↪'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i]))
        {
            return false;
        }
    }
    // Check if domain is IP. If not, 
    // it should be valid domain name
    if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1]))
    {
        $domain_array = explode(".", $email_array[1]);
        if (sizeof($domain_array) < 2)
        {
            return false; // Not enough parts to domain
        }
        for ($i = 0; $i < sizeof($domain_array); $i++)
        {
            if
            (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|
↪([A-Za-z0-9]+))$", $domain_array[$i]))
            {
                return false;
            }
        }
    }
    return true;
}


function compileError($error)
{
    return '<p class="errors mb20"><strong>Error!</strong><br/>' . $error . '</p>';
}

function compileSuccess($success)
{
    return '<p class="success mb20"><strong>Your message has been successfully sent.</strong><br/></p>';
}

function removeInvalidCharacters($input, $allowedChars = 'abcdefghijklmnopqrstuvwxyz 1234567890')
{
    $str = '';
    for ($i = 0; $i < strlen($input); $i++)
    {
        if (!stristr($allowedChars, $input[$i]))
        {
            continue;
        }

        $str .= $input[$i];
    }

    return $str;
}

function safeOutputToScreen($input, $allowedChars = null, $length = null)
{
    if ($allowedChars != null)
    {
        $input = removeInvalidCharacters($input);
    }

    if ($length != null)
    {
        if (strlen($input) > $length)
        {
            $input = substr($input, 0, $length - 3) . '...';
        }
    }

    $input = htmlspecialchars($input, ENT_QUOTES, "UTF-8");

    return $input;
}

?>
