<?php

// allow for 4 hours
set_time_limit(60*60*4);

// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');
define('IMPORT_BATCH_SIZE', 1000);

// includes and security
include_once('../../../admin/_local_auth.inc.php');

// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin');

// check for tables
$urlTableExistsQry = $db->getRows("SHOW TABLES LIKE 'prefix_fburl'");
$urlTableExists = false;
if(COUNT($urlTableExistsQry))
{
    $urlTableExists = true;
}
$usersTableExistsQry = $db->getRows("SHOW TABLES LIKE 'prefix_fbuser'");
$usersTableExists = false;
if(COUNT($usersTableExistsQry))
{
    $usersTableExists = true;
}
$statsTableExistsQry = $db->getRows("SHOW TABLES LIKE 'prefix_fbstats'");
$statsTableExists = false;
if(COUNT($statsTableExistsQry))
{
    $statsTableExists = true;
}

// get totals
if($urlTableExists)
{
    $totalUrls = (int)$db->getValue("SELECT COUNT(id) AS total FROM prefix_fburl");
}

if($usersTableExists)
{
    $totalUsers = (int)$db->getValue("SELECT COUNT(id) AS total FROM prefix_fbuser");
}

if($statsTableExists)
{
    $totalStats = (int)$db->getValue("SELECT COUNT(id) AS total FROM prefix_fbstats");
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }

    // import the data
    if (adminFunctions::isErrors() == false)
    {
        // rename id on existing user
        $db->query("DELETE FROM users");
        $db->query("DELETE FROM shorturl");
        $db->query("DELETE FROM stats");
        
        // import users
        $rs = $db->db->query("SELECT * FROM prefix_fbuser ORDER BY id");
        foreach($rs AS $row)
        {
            // insert into db
            $dbInsert = $db->query("INSERT INTO users (id, username, password, level, email, status, datecreated) VALUES (:id, :username, :password, :level, :email, :status, :datecreated)", array(
                'id' => $row['id'],
                'username' => $row['username'],
                'password' => MD5($row['password']),
                'level' => $row['admin']==1?'admin':'user',
                'email' => $row['email'],
                'status' => $row['active']==1?'active':'disabled',
                'datecreated' => $row['date'],
            ));
        }
        
        // import urls
        $rs = $db->db->query("SELECT * FROM prefix_fburl ORDER BY id");
		$tracker = 1;
		foreach($rs AS $row)
        {
			if($tracker == 1)
			{
				$sQL = "INSERT INTO shorturl (id, userId, originalUrl, shortUrl, password, expiryDate, dateCreated, createdIP, status, visits) VALUES ";
			}

			$shortUrl = $row['alias'];
			if(strlen($row['custom']))
			{
				$shortUrl = $row['custom'];
			}
			$pass = '';
			if(strlen($row['pass']))
			{
				$pass = MD5($row['pass']);
			}
			$sQL .= "(".(int)$row['id'].", ".(int)$row['userid'].", ".$db->quote($row['url']).", ".$db->quote($shortUrl).", ".$db->quote($pass).", NULL, ".$db->quote($row['date']).", NULL, 'active', ".(int)$row['click']."),";
			
			if($tracker == IMPORT_BATCH_SIZE)
			{
				$sQL = substr($sQL, 0, strlen($sQL)-1);
				$db->query($sQL);
				$tracker = 1;
			}
			else
			{
				$tracker++;
			}
        }
		$sQL = substr($sQL, 0, strlen($sQL)-1);
		$db->query($sQL);
		
		// import stats
        $rs = $db->db->query("SELECT * FROM prefix_fbstats ORDER BY id");
		$tracker = 1;
		foreach($rs AS $row)
        {
			if($tracker == 1)
			{
				$sQL = "INSERT INTO stats (id, url, dt, ip, country, referer) VALUES ";
			}

			$country = $row['country'];
			if($row['country'] > 10)
			{
				$country = substr($row['country'], 0, 10);
			}
			$sQL .= "(".(int)$row['id'].", ".$db->quote($row['short']).", ".$db->quote($row['date']).", ".$db->quote($row['ip']).", ".$db->quote($country).", ".$db->quote($row['referer'])."),";
			
			if($tracker == IMPORT_BATCH_SIZE)
			{
				$sQL = substr($sQL, 0, strlen($sQL)-1);
				$db->query($sQL);
				$tracker = 1;
			}
			else
			{
				$tracker++;
			}
        }
		$sQL = substr($sQL, 0, strlen($sQL)-1);
		$db->query($sQL);

        // done
        adminFunctions::setSuccess("The import has been completed.<br/><br/>The current logged in user has been replaced with the previous admin user details from PlusPHP. You should log out of this admin area and back in using the migrated user details. You can also remove the temporary migration tables called 'prefix_fburl', 'prefix_fbstats' & 'prefix_fbuser'.");
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2>Migrate Data</h2>
            <div class="widget_inside">
                <p>Use this plugin to migrate data from PlusPHP Short Url Script. Please copy the tables from your PlusPHP database into the this one (<?php echo _CONFIG_DB_NAME; ?>) to begin.</p>
            </div>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                
                <?php if (adminFunctions::getSuccess() == false): ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Checking Tables</h3>
                            <p>Copy the structure and data of 'prefix_fburl', 'prefix_fbstats' & 'prefix_fbuser' into this database (<?php echo _CONFIG_DB_NAME; ?>).</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Table 'prefix_fburl':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($urlTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \'prefix_fburl\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalUrls.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label>Table 'prefix_fbuser':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($usersTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \'prefix_fbuser\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalUsers.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
								<div class="clearfix alt-highlight">
                                    <label>Table 'prefix_fbstats':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($statsTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \'prefix_fbstats\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalStats.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                    if($urlTableExists == true)
                    {
                    ?>
                    <div class="clearfix col_12">
                        <div class="col_4">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Import Data" class="button blue" onClick="return confirm('Are you sure you want to import this data? All existing users and urls in the current database will be cleared and replaced with those in \'prefix_fburl\', \'prefix_fbstats\' & \'prefix_fbuser\' tables. This can not be undone so make sure you\'ve backed up everything!');">
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                    ?>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
                </form>
                <?php endif; ?>
                
            </div>
        </div>   
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>