<?php

// allow for 4 hours
set_time_limit(60*60*4);

// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');

// includes and security
include_once('../../../admin/_local_auth.inc.php');

// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin');

// check for tables
$urlTableExistsQry = $db->getRows("SHOW TABLES LIKE 'shorturl_short'");
$urlTableExists = false;
if(COUNT($urlTableExistsQry))
{
    $urlTableExists = true;
}
$usersTableExistsQry = $db->getRows("SHOW TABLES LIKE 'shorturl_users'");
$usersTableExists = false;
if(COUNT($usersTableExistsQry))
{
    $usersTableExists = true;
}

// get totals
if($urlTableExists)
{
    $totalUrls = (int)$db->getValue("SELECT COUNT(id) AS total FROM shorturl_short");
}

if($usersTableExists)
{
    $totalUsers = (int)$db->getValue("SELECT COUNT(id) AS total FROM shorturl_users");
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }

    // import the data
    if (adminFunctions::isErrors() == false)
    {
        // rename id on existing user
        $db->query("DELETE FROM users");
        $db->query("DELETE FROM shorturl");
        $db->query("DELETE FROM stats");
        
        // import users
        $rs = $db->query("SELECT * FROM shorturl_users ORDER BY id");
        while($row = mysql_fetch_array($rs, MYSQL_ASSOC))
        {
            // insert into db
            $dbInsert = $db->query("INSERT INTO users (id, username, password, level, email, status, datecreated) VALUES (:id, :username, :password, :level, :email, :status, :datecreated)", array(
                'id' => $row['id'],
                'username' => $row['login'],
                'password' => $row['pass'],
                'level' => $row['role']==60?'admin':'user',
                'email' => $row['email'],
                'status' => $row['deleted']==0?'active':'disabled',
                'datecreated' => $row['added'],
            ));
        }
        
        // import urls
        $rs = $db->query("SELECT * FROM shorturl_short ORDER BY id");
        while($row = mysql_fetch_array($rs, MYSQL_ASSOC))
        {
            // insert into db
            $dbInsert = $db->query("INSERT INTO shorturl (id, userId, originalUrl, shortUrl, password, expiryDate, dateCreated, createdIP, status) VALUES (:id, :userId, :originalUrl, :shortUrl, :password, :expiryDate, :dateCreated, :createdIP, :status)", array(
                'id' => $row['id'],
                'userId' => $row['user_id'],
                'originalUrl' => $row['url'],
                'shortUrl' => $row['tag'],
                'password' => $row['pass'],
                'expiryDate' => $row['validTill']!=0?date("Y-m-D H:i:s", $row['validTill']):NULL,
                'dateCreated' => date("Y-m-D H:i:s", $row['added']),
                'createdIP' => $row['ip'],
                'status' => $row['deleted']==0?'active':'disabled',
            ));
        }

        // done
        adminFunctions::setSuccess("The import has been completed.<br/><br/>The current logged in user has been replaced with the previous admin user details from PlusPHP. You should log out of this admin area and back in using the migrated user details. You can also remove the temporary migration tables called 'shorturl_short' & 'shorturl_users'.");
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2>Migrate Data</h2>
            <div class="widget_inside">
                <p>Use this plugin to migrate data from PlusPHP Short Url Script. Please copy the tables from your PlusPHP database into the this one (<?php echo _CONFIG_DB_NAME; ?>) to begin.</p>
            </div>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                
                <?php if (adminFunctions::getSuccess() == false): ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Checking Tables</h3>
                            <p>Copy the structure and data of 'shorturl_short' & 'shorturl_users' into this database (<?php echo _CONFIG_DB_NAME; ?>).</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Table 'shorturl_short':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($urlTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \'shorturl_short\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalUrls.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label>Table 'shorturl_users':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($usersTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \'shorturl_users\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalUsers.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                    if($urlTableExists == true)
                    {
                    ?>
                    <div class="clearfix col_12">
                        <div class="col_4">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Import Data" class="button blue" onClick="return confirm('Are you sure you want to import this data? All existing users and urls in the current database will be cleared and replaced with those in \'shorturl_short\' & \'shorturl_users\' tables. This can not be undone so make sure you\'ve backed up everything!');">
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                    ?>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
                </form>
                <?php endif; ?>
                
            </div>
        </div>   
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>