<?php

// allow for 4 hours
set_time_limit(60*60*4);

// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');

// table prex
define('TABLE_PREFIX', 'yourls_');

// includes and security
include_once('../../../admin/_local_auth.inc.php');

// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin');

// check for tables
$urlTableExistsQry = $db->getRows("SHOW TABLES LIKE '".TABLE_PREFIX."url'");
$urlTableExists = false;
if(COUNT($urlTableExistsQry))
{
    $urlTableExists = true;
}
$statsTableExistsQry = $db->getRows("SHOW TABLES LIKE '".TABLE_PREFIX."log'");
$statsTableExists = false;
if(COUNT($statsTableExistsQry))
{
    $statsTableExists = true;
}

// get totals
if($urlTableExists)
{
    $totalUrls = (int)$db->getValue("SELECT COUNT(keyword) AS total FROM ".TABLE_PREFIX."url");
}

if($statsTableExists)
{
    $totalStats = (int)$db->getValue("SELECT COUNT(click_id) AS total FROM ".TABLE_PREFIX."log");
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }

    // import the data
    if (adminFunctions::isErrors() == false)
    {
        // rename id on existing user
        $db->query("DELETE FROM shorturl");
        $db->query("DELETE FROM stats");
        
        // import users
        $rs = $db->query("SELECT * FROM ".TABLE_PREFIX."url");
        while($row = mysql_fetch_array($rs, MYSQL_ASSOC))
        {
			// insert into db
            $dbInsert = $db->query("INSERT INTO shorturl (originalUrl, urlDomainId, shortUrl, dateCreated, createdIP, status, visits) VALUES (:originalUrl, :urlDomainId, :shortUrl, :dateCreated, :createdIP, :status, :visits)", array(
                'originalUrl' => $row['url'],
				'urlDomainId' => 1,
                'shortUrl' => $row['keyword'],
                'dateCreated' => $row['timestamp'],
                'createdIP' => $row['ip'],
                'status' => 'active',
				'visits' => $row['clicks']
            ));
        }
        
        // import urls
        $rs = $db->query("SELECT * FROM ".TABLE_PREFIX."log ORDER BY click_id");
        while($row = mysql_fetch_array($rs, MYSQL_ASSOC))
        {
			// find out short url id
			$shortUrl = shortUrl::loadByUrl($row['shorturl']);
			$shortUrlId = $shortUrl->id;
			
            // insert into db
            $dbInsert = $db->query("INSERT INTO stats (page_title, dt, country, referer, user_agent, ip) VALUES (:page_title, :dt, :country, :referer, :user_agent, :ip)", array(
                'page_title' => $shortUrlId,
                'dt' => $row['click_time'],
                'country' => $row['country_code'],
                'referer' => $row['referrer'],
                'user_agent' => $row['user_agent'],
                'ip' => $row['ip_address'],
            ));
        }

        // done
        adminFunctions::setSuccess("The import has been completed.<br/><br/>You can remove the temporary migration tables called '".TABLE_PREFIX."url' & '".TABLE_PREFIX."log'.");
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2>Migrate Data</h2>
            <div class="widget_inside">
                <p>Use this plugin to migrate data from Yourls Short Url Script. Please copy the 'url' &amp; 'log' table from your Yourls database into the this one (<?php echo _CONFIG_DB_NAME; ?>), ensuring you prefix them with <?php echo TABLE_PREFIX; ?>, to begin. You should end up with 2 new tables in this database called '<?php echo TABLE_PREFIX; ?>url' &amp; '<?php echo TABLE_PREFIX; ?>log'.</p>
            </div>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                
                <?php if (adminFunctions::getSuccess() == false): ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Checking Tables</h3>
                            <p>Copy the structure and data of '<?php echo TABLE_PREFIX; ?>url' & '<?php echo TABLE_PREFIX; ?>log' into this database (<?php echo _CONFIG_DB_NAME; ?>).</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Table '<?php echo TABLE_PREFIX; ?>url':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($urlTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \''.TABLE_PREFIX.'url\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalUrls.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label>Table '<?php echo TABLE_PREFIX; ?>log':</label>
                                    <div class="input" style='padding-top: 6px;'>
                                        <?php
                                        if($statsTableExists == false)
                                        {
                                            echo '<span style="color: red;">Error, could not find the \''.TABLE_PREFIX.'log\' or load any data from it.</span>';
                                        }
                                        else
                                        {
                                            echo '<span style="color: green;">Found '.$totalStats.' rows to import.</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                    if($urlTableExists == true)
                    {
                    ?>
                    <div class="clearfix col_12">
                        <div class="col_4">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Import Data" class="button blue" onClick="return confirm('Are you sure you want to import this data? All existing urls and stats in the current database will be cleared and replaced with those in \'<?php echo TABLE_PREFIX; ?>log\' & \'<?php echo TABLE_PREFIX; ?>log\' tables. This can not be undone so make sure you\'ve backed up everything!');">
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                    ?>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
                </form>
                <?php endif; ?>
                
            </div>
        </div>   
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>